﻿local path = __dirname:gsub("\\", "/")
if not path:match("/$") then
    path = path .. "/"
end
path = path .. "dadosLeft.txt"

local lastContent = ""
local RT, ET, TT = "", "", ""

local function getFormattedValue(str)
    local value = str:match("(.*)")
    if not value then return "" end

    local beforeDot, afterDot = value:match("^(%d+)%.(.*)$")
    if beforeDot and #beforeDot == 1 then
        return " " .. beforeDot .. "." .. afterDot
    end

    return value
end

function update(dt)
    local file = io.open(path, "r")
    if file then
        local content = file:read("*all")
        file:close()

        if content ~= lastContent then
            lastContent = content
            local linhas = {}
            for line in content:gmatch("[^\r\n]+") do
                table.insert(linhas, line)
            end

            ET = linhas[2] and getFormattedValue(linhas[2])
            SPEED = linhas[3] and getFormattedValue(linhas[3]) 
            DIAL = linhas[4] and getFormattedValue(linhas[4])
        end
    end

    display.text{ pos=vec2(30,15),  alignment=1, letter=vec2(40,60), text=ET, font="led_g333", spacing=-7, color=rgbm(1,0,0,1) }	
    display.text{ pos=vec2(30,100),  alignment=1, letter=vec2(40,60), text=SPEED, font="led_g333", spacing=-7, color=rgbm(1,0,0,1) }
    display.text{ pos=vec2(30,180),  alignment=1, letter=vec2(40,60), text=DIAL, font="led_g333", spacing=-7, color=rgbm(1,0,0,1) }
 
end
