-- Launch Control Script
-- By Sayrx

local launchControlActive = false

function script.update(dt)
    local gear = car.gear
    local physics = ac.accessCarPhysics()
    
    -- Check if K key is held and car is in neutral
    if ac.isKeyDown(ac.KeyIndex.K) and gear == 0 then
        launchControlActive = true
        
        -- Limit RPM to 4500
        if physics.rpm > 4500 then
            physics.rpm = 4500
        end
    else
        launchControlActive = false
    end
    
    -- Display "LAUNCH CONTROL ON" when active
    if launchControlActive then
        display.text {
            text = "LAUNCH CONTROL ON",
            pos = vec2(400, 600),
            letter = vec2(20, 30),
            color = rgbm(1, 0.3, 0.3, 1),  -- Red
            font = '4c',
            alignment = 0
        }
    end
end
