-- Define OLED object names
local oledObjects = {}
for i = 1, 33 do
    oledObjects[i] = "rear_led_" .. i
end

-- Define sequences for each phase
local phase1Row1 = {1, 2, 3, 4, 5, 6, 7, 8, 9, 10}
local phase1Row2 = {21, 22, 23, 24, 25, 26, 27, 28, 29, 30}
local phase2Row1 = {10, 9, 8, 7, 6, 5, 4, 3, 2, 1}
local phase2Row2 = {20, 19, 18, 17, 16, 15, 14, 13, 12, 11}
local phase2Row3 = {30, 29, 28, 27, 26, 25, 24, 23, 22, 21}
local phase2Row4 = {33, 32, 31}

-- Variables for animation
local startTime = 0
local phase = 1
local step = 1

-- Function to update OLED taillights
function updateOLEDs(dt)
    local headlightsActive = ac.getCar().headlightsActive

    if headlightsActive then
        if startTime == 0 then
            startTime = ac.getSimulationTime()
        end
        local elapsedTime = ac.getSimulationTime() - startTime

        if elapsedTime < 1 then
            -- Phase 1: Light up phase1Row1 and phase1Row2
            for _, led in ipairs(phase1Row1) do
                ac.findMeshes(oledObjects[led]):setMaterialProperty('ksEmissive', rgb(1, 0, 0)) -- Red
            end
            for _, led in ipairs(phase1Row2) do
                ac.findMeshes(oledObjects[led]):setMaterialProperty('ksEmissive', rgb(1, 0, 0)) -- Red
            end
        elseif elapsedTime < 2 then
            -- Phase 2: Calculate step based on elapsed time
            local phase2ElapsedTime = elapsedTime - 1
            step = math.floor(phase2ElapsedTime / 0.1) + 1
            if step > #phase2Row1 then
                step = #phase2Row1
            end
            -- Light up phase2Row1, phase2Row2, phase2Row3, phase2Row4 for current step
            ac.findMeshes(oledObjects[phase2Row1[step]]):setMaterialProperty('ksEmissive', rgb(1, 0, 0)) -- Red
            ac.findMeshes(oledObjects[phase2Row2[step]]):setMaterialProperty('ksEmissive', rgb(1, 0, 0)) -- Red
            ac.findMeshes(oledObjects[phase2Row3[step]]):setMaterialProperty('ksEmissive', rgb(1, 0, 0)) -- Red
            if step <= #phase2Row4 then
                ac.findMeshes(oledObjects[phase2Row4[step]]):setMaterialProperty('ksEmissive', rgb(1, 0, 0)) -- Red
            end
        else
            -- Phase 2: All LEDs on
            for _, led in ipairs(phase2Row1) do
                ac.findMeshes(oledObjects[led]):setMaterialProperty('ksEmissive', rgb(1, 0, 0)) -- Red
            end
            for _, led in ipairs(phase2Row2) do
                ac.findMeshes(oledObjects[led]):setMaterialProperty('ksEmissive', rgb(1, 0, 0)) -- Red
            end
            for _, led in ipairs(phase2Row3) do
                ac.findMeshes(oledObjects[led]):setMaterialProperty('ksEmissive', rgb(1, 0, 0)) -- Red
            end
            for _, led in ipairs(phase2Row4) do
                ac.findMeshes(oledObjects[led]):setMaterialProperty('ksEmissive', rgb(1, 0, 0)) -- Red
            end
        end
    else
        -- Turn off all OLEDs when headlights are off
        for i = 1, 33 do
            ac.findMeshes(oledObjects[i]):setMaterialProperty('ksEmissive', rgb(0, 0, 0)) -- Off
        end
        -- Reset variables for next animation
        startTime = 0
        phase = 1
        step = 1
    end
end

-- Register the update function
function script.update(dt)
    updateOLEDs(dt)
end