local padding = system.narrowMode and 80 or 160
carList = {}
local carinBlindSpotLeft = false
local carinBlindSpotRight = false
local carinBlindSpotLeftTimer = 0
local carinBlindSpotRightTimer = 0

for i = 0, ac.getSimState().carsCount, 1 do
    if (ac.getCar(i) ~= nil) then
        carList[i] = {car = ac.getCar(i),carinBlindSpotLeftTimer = 0, carinBlindSpotRightTimer = 0}
    end
end

function calculateCarsPositionsw()
    for i = 0, ac.getSimState().carsCount, 1 do
        if (ac.getCar(i) ~= nil) then
            carList[i] = {car = ac.getCar(i),carinBlindSpotLeftTimer = carList[i].carinBlindSpotLeftTimer, carinBlindSpotRightTimer = carList[i].carinBlindSpotRightTimer}
        end
    end
end

function translateCoordinatesFromRotation(center, pos)
    local angleRads = -math.rad(ac.getCompassAngle(ac.getCar().look))
    return vec2(center.x + (pos.x - center.x) * math.cos(angleRads) - (pos.y - center.y) * math.sin(angleRads),
        center.y + (pos.x - center.x) * math.sin(angleRads) + (pos.y - center.y) * math.cos(angleRads))
end

function checkLeftBlindSpot()
    local found = false
    for i = 1, table.getn(carList), 1 do
        --print(carList[i].carinBlindSpotLeftTimer)
        if (carList[i].carinBlindSpotLeftTimer > 1) then
            found = true
            carinBlindSpotLeft = true
            break
        end
    end

    if(found == false) then carinBlindSpotLeft = false end

    if (carinBlindSpotLeft) then
        ac.findMeshes("Plane.014"):setMaterialProperty('ksEmissive', rgb(15, 10, 0) * 5) -- metal_detail.dds
    else
        if (ac.getCar().headlightsActive == true) then
            ac.findMeshes("Plane.014"):setMaterialProperty('ksEmissive', rgb(0, 1.5, 15)) -- metal_detail.dds
        else
            ac.findMeshes("Plane.014"):setMaterialProperty('ksEmissive', rgb(0, 0, 0))
        end
    end

end

function checkRightBlindSpot()
    local found = false
    for i = 1, table.getn(carList), 1 do
        if (carList[i].carinBlindSpotRightTimer > 1) then
          found = true
            carinBlindSpotRight = true
            break
        end
    end

    if(found == false) then carinBlindSpotRight = false end

    if (carinBlindSpotRight) then
        ac.findMeshes("Plane.015"):setMaterialProperty('ksEmissive', rgb(15, 10, 0) * 5) -- metal_detail.dds
    else
        if (ac.getCar().headlightsActive == true) then
            ac.findMeshes("Plane.015"):setMaterialProperty('ksEmissive', rgb(0, 1.5, 15)) -- metal_detail.dds
        else
            ac.findMeshes("Plane.015"):setMaterialProperty('ksEmissive', rgb(0, 0, 0))
        end
    end

end

function displayCarRadar(dt)
    local scale = 15.0
    calculateCarsPositionsw()
    local center = vec2(carList[0].car.position.x, carList[0].car.position.z)
    -- printCarList()
    local testcolor = rgbm(1, 1, 1, 1)
    local centerPosition = (vec2(ui.availableSpaceX() / 2, ui.availableSpaceY() / 2))
    ui.drawCircleFilled(centerPosition, 10, rgbm(1, 1, 1, 1), scale * 20)
    for i = 1, table.getn(carList), 1 do
        local carposition = (carList[0].car.position - carList[i].car.position)
        local car2dposition = ((scale * vec2(carposition.x, carposition.z)) + centerPosition)
        local translatedCoordinates = translateCoordinatesFromRotation(centerPosition, car2dposition)
        local tyre1 = (carList[0].car.position - carList[i].car.wheels[0].position)
        tyre1 = (scale * vec2(tyre1.x, tyre1.z)) + centerPosition
        local translatedTyre1 = translateCoordinatesFromRotation(centerPosition, tyre1)
        -- print(tyre1)
        local tyre2 = (carList[0].car.position - carList[i].car.wheels[1].position)
        tyre2 = (scale * vec2(tyre2.x, tyre2.z)) + centerPosition
        local translatedTyre2 = translateCoordinatesFromRotation(centerPosition, tyre2)

        local tyre3 = (carList[0].car.position - carList[i].car.wheels[2].position)
        tyre3 = (scale * vec2(tyre3.x, tyre3.z)) + centerPosition
        local translatedTyre3 = translateCoordinatesFromRotation(centerPosition, tyre3)

        local tyre4 = (carList[0].car.position - carList[i].car.wheels[3].position)
        tyre4 = (scale * vec2(tyre4.x, tyre4.z)) + centerPosition
        local translatedTyre4 = translateCoordinatesFromRotation(centerPosition, tyre4)
        local translatedcentertyre = vec2((translatedTyre1.x + translatedTyre2.x) / 2,
            (translatedTyre1.y + translatedTyre4.y) / 2)

        local centertyre = vec2((tyre1.x + tyre2.x) / 2, (tyre1.y + tyre4.y) / 2)
        local p1 = centerPosition + vec2(-75, -25)
        local p2 = centerPosition + vec2(-10, 100)
        local p3 = centerPosition + vec2(10, -25)
        local p4 = centerPosition + vec2(75, 100)

        -- print('index ' .. i .. ': ' .. translatedCoordinates.x .. ',' .. translatedCoordinates.y)
        -- print('index ' .. 0 .. ': ' .. p1.x .. ',' .. p1.y)
        -- print('index 0: ' .. centerPosition.x .. ',' .. centerPosition.y)
        -- print(tyre2)
        if (translatedCoordinates.x > p1.x and translatedCoordinates.x < p2.x and translatedCoordinates.y > p1.y and
            translatedCoordinates.y < p2.y) then
            -- if(carList[i].wheels[0].position.x > carList[0].position.x - 30 and carList[i].wheels[0].position.x < carList[0].position.x and carList[i].wheels[0].position.z > carList[0].position.z and carList[i].wheels[0].position.z < carList[0].position.z + 50) then
            testcolor = rgbm(0, 1, 0, 1)
            carList[i].carinBlindSpotLeftTimer = carList[i].carinBlindSpotLeftTimer + dt
        else
            carList[i].carinBlindSpotLeftTimer = 0
            testcolor = rgbm(1, 1, 1, 1)
        end

        if (translatedCoordinates.x > p3.x and translatedCoordinates.x < p4.x and translatedCoordinates.y > p3.y and
            translatedCoordinates.y < p4.y) then
            -- if(carList[i].wheels[0].position.x > carList[0].position.x - 30 and carList[i].wheels[0].position.x < carList[0].position.x and carList[i].wheels[0].position.z > carList[0].position.z and carList[i].wheels[0].position.z < carList[0].position.z + 50) then
            testcolor = rgbm(0, 1, 0, 1)
            carList[i].carinBlindSpotRightTimer = carList[i].carinBlindSpotRightTimer + dt
        else
            carList[i].carinBlindSpotRightTimer = 0
            testcolor = rgbm(1, 1, 1, 1)
        end
        -- ui.drawCircleFilled(translatedCoordinates, 10 * (scale / 3), rgbm(2, 0, 0, 1), scale * 20)
        --ui.drawRect(p1, p2, rgbm(1, 0, 0, 1), false, 20)
        --ui.drawRect(p3, p4, rgbm(1, 0, 0, 1), false, 20)
        ui.drawQuadFilled(translatedTyre1, translatedTyre2, translatedTyre4, translatedTyre3, rgbm(1, 1, 1, 1))
    end
    checkLeftBlindSpot()
    checkRightBlindSpot()
    --  ui.drawRect(vec2(centerPosition.x - 30, centerPosition.y), vec2(centerPosition.x, centerPosition.y + 50),
    --     rgbm(1, 1, 1, 1), false, 20)
end

return function(dt)
    touchscreen.boostFrameRate()
    ui.childWindow('Radar', vec2(ui.availableSpaceX(), ui.availableSpaceY()), function()
        ui.offsetCursorY(30)
        ui.indent(padding)

        displayCarRadar(dt)

        ui.unindent(padding)
        ui.offsetCursorY(40)
    end)
end
