-- Assetto Corsa Car Extension Script: Turn Signal Sound
-- This script plays an MP3 sound when turn signals are activated

-- Get car state
local car = ac.getCar(0)  -- 0 for player car

-- Audio events for turn signals
local turnSignalSoundLeft = nil
local turnSignalSoundRight = nil

-- Track previous turn signal state to detect changes
local prevLeftSignal = false
local prevRightSignal = false

-- Initialize audio events
function script.update(dt)
    -- Get current turn signal states
    local leftSignalOn = car.turningLeftLights
    local rightSignalOn = car.turningRightLights
    
    -- Detect left turn signal activation
    if leftSignalOn and not prevLeftSignal then
        -- Left turn signal just turned on
        if turnSignalSoundLeft == nil or not turnSignalSoundLeft:isValid() then
            -- Create audio event from MP3 file
            -- Replace 'turnsignal.mp3' with the path to your MP3 file
            -- Path can be relative to the car's folder or absolute
            turnSignalSoundLeft = ac.AudioEvent.fromFile({
                filename = 'turnsignal.mp3',  -- Adjust path as needed
                loop = false,  -- Don't loop the sound
                use3D = true   -- Use 3D positioning
            }, false)
        end
        
        if turnSignalSoundLeft and turnSignalSoundLeft:isValid() then
            turnSignalSoundLeft:setPosition(car.position, car.look, car.up, car.velocity)
            turnSignalSoundLeft:start()
        end
    end
    
    -- Detect right turn signal activation
    if rightSignalOn and not prevRightSignal then
        -- Right turn signal just turned on
        if turnSignalSoundRight == nil or not turnSignalSoundRight:isValid() then
            -- Create audio event from MP3 file
            turnSignalSoundRight = ac.AudioEvent.fromFile({
                filename = 'turnsignal.mp3',  -- Adjust path as needed
                loop = false,
                use3D = true
            }, false)
        end
        
        if turnSignalSoundRight and turnSignalSoundRight:isValid() then
            turnSignalSoundRight:setPosition(car.position, car.look, car.up, car.velocity)
            turnSignalSoundRight:start()
        end
    end
    
    -- Update audio positions if sounds are playing
    if turnSignalSoundLeft and turnSignalSoundLeft:isPlaying() then
        turnSignalSoundLeft:setPosition(car.position, car.look, car.up, car.velocity)
    end
    
    if turnSignalSoundRight and turnSignalSoundRight:isPlaying() then
        turnSignalSoundRight:setPosition(car.position, car.look, car.up, car.velocity)
    end
    
    -- Update previous states
    prevLeftSignal = leftSignalOn
    prevRightSignal = rightSignalOn
end

-- Cleanup when script is disposed
function script.dispose()
    if turnSignalSoundLeft then
        turnSignalSoundLeft:dispose()
    end
    if turnSignalSoundRight then
        turnSignalSoundRight:dispose()
    end
end
