-- Generated AC Lua Script
-- Request: Show speed and gear and rpm and turbo and engine temp and oil pressure and make it flash red when rpm is high
-- Displaying: speed, gear, rpm, temperature, turbo

function script.update(dt)
    local speed = car.speedKmh or 0
    local gear = car.gear or 0
    local rpm = car.rpm or 0
    local temp = car.waterTemperature or 0
    local boost = car.turboBoost or 0

    -- Display speed
    display.text{
        text = string.format("%.0f km/h", speed),
        pos = vec2(64, 20),
        letter = vec2(25, 30),
        color = rgbm(1, 1, 1, 1),
        font = 'default'
    }

    -- Display gear
    display.text{
        text = "Gear: " .. tostring(gear),
        pos = vec2(64, 55),
        letter = vec2(25, 30),
        color = rgbm(1, 1, 1, 1),
        font = 'default'
    }

    -- Display RPM
    display.text{
        text = string.format("%.0f RPM", rpm),
        pos = vec2(64, 90),
        letter = vec2(20, 25),
        color = rgbm(1, 1, 1, 1),
        font = 'default'
    }

    -- Display temperature
    display.text{
        text = string.format("%.0f°C", temp),
        pos = vec2(64, 125),
        letter = vec2(25, 30),
        color = rgbm(1, 1, 1, 1),
        font = 'default'
    }

    -- Display turbo
    display.text{
        text = string.format("%.2f bar", boost),
        pos = vec2(64, 160),
        letter = vec2(20, 25),
        color = rgbm(1, 1, 1, 1),
        font = 'default'
    }
end

-- Available display functions in AC:
-- display.text{} - Draw text with font
-- ui.drawRectFilled(p1, p2, color) - Draw filled rectangle
-- ui.drawImage(image, p1, p2, color) - Draw image
--
-- Common parameters:
-- vec2(x, y) - Position vectors
-- rgbm(r, g, b, a) - Color with alpha (0-1 values)
-- For display.text:
--   pos = position, letter = character size
--   color = text color, font = font name
--   alignment = text alignment (0=left, 1=right, 1.5=center)