-- Blinker Sound Script for Car
-- This script plays MP3 sounds when turn signals are activated

-- State variables
local leftBlinkerSound = nil
local rightBlinkerSound = nil
local lastLeftBlinkerState = false
local lastRightBlinkerState = false

-- Initialize audio events
function script.init()
    -- Create audio events for blinker sounds (2D audio, no positioning)
    -- You need to place your MP3 files in the same folder as this script
    leftBlinkerSound = ac.AudioEvent.file({
        filename = 'indicator.mp3',  -- Replace with your left blinker sound file
        use3D = false,  -- Disable 3D positioning
        loop = false
    }, false)
    
    rightBlinkerSound = ac.AudioEvent.file({
        filename = 'indicator.mp3',  -- Replace with your right blinker sound file
        use3D = false,  -- Disable 3D positioning
        loop = false
    }, false)
    
    -- Set volume for better audibility
    if leftBlinkerSound then
        leftBlinkerSound.volume = 1.0
    end
    
    if rightBlinkerSound then
        rightBlinkerSound.volume = 1.0
    end
end

-- Main update function
function script.update(dt)
    -- Get car data
    local car = ac.getCar(0)  -- Get player's car (index 0)
    
    if car then
        -- Check turn signal states
        local leftBlinkerOn = car.turningLeftLights
        local rightBlinkerOn = car.turningRightLights
        
        -- Detect left blinker activation (off -> on transition)
        if leftBlinkerOn and not lastLeftBlinkerState then
            if leftBlinkerSound and leftBlinkerSound:isValid() then
                leftBlinkerSound:start()
                ac.debug("Blinker", "Left blinker sound played!")
            end
        end
        
        -- Detect right blinker activation (off -> on transition)
        if rightBlinkerOn and not lastRightBlinkerState then
            if rightBlinkerSound and rightBlinkerSound:isValid() then
                rightBlinkerSound:start()
                ac.debug("Blinker", "Right blinker sound played!")
            end
        end
        
        -- Update previous states
        lastLeftBlinkerState = leftBlinkerOn
        lastRightBlinkerState = rightBlinkerOn
    end
end

-- Cleanup function
function script.dispose()
    if leftBlinkerSound then
        leftBlinkerSound:dispose()
    end
    if rightBlinkerSound then
        rightBlinkerSound:dispose()
    end
end