if car.isAIControlled then
  return nil
end
local counter = 0

function script.update(dt)
  local data = ac.accessCarPhysics()

  if not car.extraD then
    data.rpm = 0
    counter = 0
  elseif counter < 1.5 then
    if counter < 0.5 then
      data.rpm = 0
    else
      data.gas = 0.3
    end
    counter = counter + dt
  end
end

local function interpolate(x1, x2, input, y1, y2)
	input = math.clamp(input, x1, x2)
	return y1 + ((input - x1) / (x2 - x1)) * (y2 - y1)
end

local function interpolate_v2(x1, x2, x3, input, y1, y2, y2)
	input = math.clamp(input, x1, x2, x3)
	return y1 + ((input - x1) / (x3 - x2 - x1)) * (y3 - y2 - y1)
end

local function safe(input) -- help prevent stupid issues when logging
	if type(input) == "table" then
		return "table"
	end
	return input
end
local function log(input)
	if true then
		ac.log("![auto] " .. safe(input))
	end
end
local function bug(name, value)
	if true then
		ac.debug("![auto] " .. name, value)
	end
end

------------------------------------------------------------------------------------------------------------------

-- Locals - Controls

local prefix = "__EXT_CAR_"
local postfixDown = "_DN"
local postfixUp = "_UP"

local driveModeButtonDown = ac.ControlButton(prefix .. "DRIVE_MODE" .. postfixDown)
local driveModeButtonUp = ac.ControlButton(prefix .. "DRIVE_MODE" .. postfixUp)

local driveModeButtonMPS = {}
-- Starting at 2 so that the drivemodes line up with the GearboxDriveModes
for i = 2, 4 do
	driveModeButtonMPS[i] = ac.ControlButton(prefix .. "DRIVE_MODE" .. "_" .. i - 1)
end

local reverseGearButton = ac.ControlButton(prefix .. "REVERSE_GEAR")
local neutralGearButton = ac.ControlButton(prefix .. "NEUTRAL_GEAR")
local manualModeButton = ac.ControlButton(prefix .. "MANUAL_MODE")
local launchControlActiveButton = ac.ControlButton(prefix .. "LAUNCH_CONTROL_ACTIVE")
local launchControlDownButton = ac.ControlButton(prefix .. "LAUNCH_CONTROL_DN")
local launchControlUpButton = ac.ControlButton(prefix .. "LAUNCH_CONTROL_UP")

-- Locals - General
local is_car_script = (ac.accessCarPhysics ~= nil)
ac.log("is_car_script: " .. (is_car_script and "true" or "false"))

local data = is_car_script
local data = ac.accessCarPhysics()
--local data = ac.getJoypadState()
local car = ac.getCar(0)
local phy = ac.getCarPhysics(0)
local gear, speed, rpm, throttle, braking = 0, 0, 0, 0, 0
local auto = {}
local target = 0
local target_max = 0
local ready = false
local shift_lock = 0
local shift_paddle_lock = 0
local kickdown = false
local kickdown_gear = 0
local logic_gear_up = 0
local logic_gear_dn = 0
local paddle_shift_up = ac.isControllerGearUpPressed()
local paddle_shift_dn = ac.isControllerGearDownPressed()
local allow_paddle_shift = false
local shift_lag = 0.25

-- Locals - Launch Control

local lc_counter = 0
local launch_control_ready = 0
local launch_control_on = 0
local launch_control_rpm = 5000
local launch_control_speed = 30
local stock_final_drive = 2.992 -- take the value from "your car / drivetrain.ini / gears / final"

-- Locals - Gearbox Driving Modes

local gearbox_valve_1 = false
local gearbox_valve_2 = false
local gearbox_valve_overdrive = false
local autoShift = ac.autoShift
local throttle_mode_normal = false
local throttle_mode_sport = false
local throttle_mode_race = false

---@alias GearboxDriveModes
---| `GearboxDriveModes.Reverse` @Value: 0.
---| `GearboxDriveModes.Neutral` @Value: 1.
---| `GearboxDriveModes.Normal` @Value: 2.
---| `GearboxDriveModes.Sport` @Value: 3.
---| `GearboxDriveModes.Track` @Value: 4.
local GearboxDriveModes = {
	Reverse = 0,
	Neutral = 1,
	Normal = 2,
	Sport = 3,
	Track = 4,
}

local gearbox_valve = GearboxDriveModes.Neutral
local gearbox_valve_manual = false

-- Locals - Chassis Driving Modes

local drivemode_comfort = false
local drivemode_sport = false
local drivemode_track = false
local drivemode_race = false

-- Locals - Clutch Control

local clutch_speed_high = 0
local clutch_speed_mid = 0
local clutch_speed_off = 0
local clutch_rpm_bite = 0
local clutch_bitepoint = 0
local clutch_min = 0
local clutch_max = 0
local clutch_on = false
local clutch_off = false

-- Locals - Debug
local ptratio = (car.drivetrainPower * throttle)
local ttratio = (car.drivetrainTorque * throttle)
local speed_mph = speed / 1.60934

------------------------------------------------------------------------------------------------------------------

--[[ Shifting -- old shifting code. Its obsolete now but keep it in case something breaks :>

    local   up = 0 -- constant
    local down = 1 -- constant

	function shift(dir)

		if (dir == up) then
			data.gearUp = true
			data.gearDown = false
		end

		if (dir == down) then
			data.gearUp = false
			data.gearDown = true
		end

	end]]

------------------------------------------------------------------------------------------------------------------
function script.update(dt)
	------------------------------------------------------------------------------------------------------------------
	-- Debugging
	bug("! Running", " ")

	gear = data.gear or 0
	speed = data.speedKmh or 0
	rpm = data.rpm or 0
	throttle = data.gas or 0
	braking = data.brake or 0

	-- Remove reverse from gear index (neutral=0, first=1, ...)
	if gear >= 0 then
		gear = gear - 1
	end

	--Debug
	ptratio = (car.drivetrainPower * throttle)
	ttratio = (car.drivetrainTorque * throttle)
	speed_mph = speed / 1.60934
	ac.debug("Car Wheel Power", ptratio)
	ac.debug("Car Wheel Torque", ttratio)
	ac.debug("Car Speed KMH", speed)
	ac.debug("Car Speed MPH", speed_mph)
	ac.debug("Car Engine RPM", rpm)
	ac.debug("Car Throttle", throttle)
	ac.debug("Car Brake", braking)
	ac.debug("Car Gear", car.gear)
	ac.debug("Car Clutch", data.clutch)
	ac.debug("Car Clutch Max", clutch_max)
	ac.debug("Shift Target", target)
	ac.debug("Shift Target Max", target_max)
	ac.debug("Shift Lock", shift_lock)
	--ac.debug("Shift Paddle Lock", shift_paddle_lock)
	ac.debug("LC Timer", lc_counter)
	ac.debug("LC ON", launch_control_on)
	ac.debug("LC Ready", launch_control_ready)
	ac.debug("LC OFF Speed", launch_control_speed)
	ac.debug("AC Auto Shift", ac.autoShift)
	ac.debug("Logic Gear Up", logic_gear_up)
	ac.debug("Logic Gear Dn", logic_gear_dn)
	ac.debug("Logic Allow P.Shift", allow_paddle_shift)
	ac.debug("Logic Shift Lag", shift_lag)

	--Disable (diagnostic)
	--if (true) then return end

	------------------------------------------------------------------------------------------------------------------

	-- Throttle Cut And Blip -- new code to cooperate with new clutch control

	if logic_gear_up > 0 then
		if logic_gear_up > 0.193 then
			data.gas = throttle * interpolate(0, 1, throttle, 1, 0.45) * interpolate(1, 110, car.speedKmh, 0.75, 1)
		elseif logic_gear_up < 0.193 then
			data.gas = throttle
				* interpolate(0, 0.193, logic_gear_up, 1, 0.45)
				* interpolate(1, 110, car.speedKmh, 0.1, 1)
		else
			data.gas = throttle
		end
	end

	if logic_gear_dn > 0 and throttle == 0 then
		if logic_gear_dn > 0.353 then
			data.gas = 1 * interpolate(1000, 6500, car.rpm, 0.5, 0.45) * interpolate(5, 30, car.speedKmh, 0.05, 1)
		elseif logic_gear_dn < 0.353 then
			data.gas = 1
				* interpolate(0, 0.353, logic_gear_dn, 0, 1)
				* interpolate(1000, 6500, car.rpm, 0.5, 0.45)
				* interpolate(5, 30, car.speedKmh, 0.05, 1)
		end
	elseif logic_gear_dn > 0 and throttle > 0 then
		if logic_gear_dn > 0.353 then
			data.gas = throttle * interpolate(1000, 6500, car.rpm, 0.6, 0.85) * interpolate(5, 30, car.speedKmh, 0.2, 1)
		elseif logic_gear_dn < 0.353 then
			data.gas = throttle
				* interpolate(0, 0.353, logic_gear_dn, 2, 1)
				* interpolate(1000, 6500, car.rpm, 0.6, 0.85)
				* interpolate(5, 30, car.speedKmh, 0.2, 1)
		end
	end

	------------------------------------------------------------------------------------------------------------------

	-- Launch Control

	if car.speedKmh < 1 and car.gear == 1 and car.tractionControlModes > 0 then
		lc_counter = lc_counter + dt
	else
		lc_counter = 0
	end

	if lc_counter >= 1 then
		launch_control_on = 1
		ac.setMessage(
			"Launch Control is ON. Push brake and gas pedals."
		)
	elseif car.speedKmh >= launch_control_speed then
		launch_control_on = 0
		launch_control_speed = 30
		launch_control_rpm = 5000
	end

	if launch_control_on == 1 and braking > 0.75 and car.gear == 1 then
		launch_control_ready = 1
	else
		launch_control_ready = 0
	end

	if launch_control_on == 1 and throttle > 0 and data.rpm >= launch_control_rpm then
		data.rpm = data.rpm - ((data.rpm - launch_control_rpm) + 100)
		if throttle == 1 and car.speedKmh >= 0.1 then
			data.rpm = launch_control_rpm
		else
			data.rpm = data.rpm
		end
	end

	if car.speedKmh < 1 and data.gear == 2 and launch_control_on > 0 then
		if braking >= 0.75 and throttle > 0 then
			data.brake = 1
			if car.turboBoosts[0] > 0.72 then
				ac.setMessage("Launch Control is ready. Release brake pedal to start.")
			end
		end
	end

	if launch_control_ready == 1 then
		ac.setGearsFinalRatio(stock_final_drive - stock_final_drive)
	elseif launch_control_ready == 0 then
		ac.setGearsFinalRatio(stock_final_drive)
	end

	------------------------------------------------------------------------------------------------------------------

	-- Clutch Control - test

	--clutch_rpm_bite = 1000 * interpolate(0,1, throttle, 1.5, 3.5)
	--clutch_speed_off = clutch_speed_bite + (20 * interpolate(0,1, throttle, 0.25, 1))
	clutch_speed_bite = 1 * interpolate(0, 1, throttle, 15, 40)
	clutch_min = 0.075
	clutch_max = (0.50 + (data.gas * 0.4999)) - (logic_gear_up * 0.5)

	if car.gear == -1 or car.gear >= 1 then
		if throttle == 0 then
			data.clutch = clutch_max * interpolate(750, 1250, car.rpm, 0.0, 1)
		elseif throttle > 0 then
			if car.speedKmh < clutch_speed_bite then
				data.clutch = 1 * interpolate(1000, 3000, car.rpm, 0.0, 1)
			elseif car.speedKmh > clutch_speed_bite then
				data.clutch = data.clutch
			end
		end
	elseif car.gear == 0 then
		data.clutch = 0
	end

	if car.rpm < 1000 then
		if car.gear == 1 or car.gear == -1 then
			if braking > 0 and car.speedKmh < 1 then
				data.clutch = 0
				clutch_min = 0
			end
		end
	end

	if data.clutch < clutch_min then
		data.clutch = clutch_min
	elseif data.clutch > clutch_max then
		data.clutch = clutch_max
	end

	if car.rpm < 740 and car.gear ~= 0 then
		data.gas = 1 * interpolate(550, 740, car.rpm, 0.5, 0)
	end

	--return math.applyLag(clutch_max, 0.5, dt)

	--[[ Clutch control for semi-automatic, dual clutch and other gearboxes which don't use hydrokinetic clutch

	if logic_gear_up ~= 0 then
		if logic_gear_up > 0.173 then
			data.clutch = 0
			elseif logic_gear_up < 0.173 then
				data.clutch = 1 * interpolate(0, 0.173, logic_gear_up, 0.5, 0)
				elseif logic_gear_up == 0 then
					data.clutch = data.clutch
		end
	end

	if logic_gear_dn ~= 0 then
		if logic_gear_dn > 0.303 then
			data.clutch = 0
			elseif logic_gear_dn < 0.303 then
				data.clutch = 1 * interpolate(0, 0.303, logic_gear_dn, 0.5, 0)
				elseif logic_gear_dn == 0 then
					data.clutch = data.clutch
		end
	end]]

	------------------------------------------------------------------------------------------------------------------

	--[[ Mechanical Throttle Body -- used for older cars -- by Stereo

	local data = ac.accessCarPhysics()
	data.enforceCustomInputScheme = true
	user_gas = data.gas
	-- remap throttle pedal to behave as a mechanical throttle rather than drive by wire
	data.gas = throttle_module(data.gas, data.rpm)

	function throttle_module(gas, rpm)
	-- convert throttle travel to area of open throttle
	local air_size = 1.0 - math.cos(gas * math.pi/2.0)
	-- make part throttle more effective below max rpm
	proportion = math.clamp(max_rpm / rpm, 1, 8) -- clamp how steeply rpm can rise
	prop_gas = math.min(proportion*air_size, 0.8+0.2*air_size)
	-- ac.debug("prop gas",prop_gas)
	return prop_gas
	end]]

	------------------------------------------------------------------------------------------------------------------

	--[[ Ignition and Engine Starter -- by CheesyManiac

	local carState = {
		ignition = false,
		cranking = false,
		crankAllowed = true
	}

	local carInfo = {
		0.6, --starter overrun time in seconds
		ac.INIConfig.carData(0, 'engine.ini'):get('ENGINE_DATA', 'MINIMUM', 900) --engine idle value
	}

	ac.setEngineStalling(true)
		local engineStartRPM = 1300
		local crankTime = 0
		local cd = 0
		local CARPM = 0
		local tmp = 0
		local carRPM = 0

	function script.update(dt)
		CAR = ac.accessCarPhysics()
		carInputs = {
			ignition = car.extraB,
			cranking = car.extraC,
			clutch = CAR.clutch
		}

		--local dt because csp aint got nothing
		cd = cd + 0.003
		----------------------------

		if carInputs.cranking and carState.crankAllowed and CAR.rpm < carInfo[2] then
			crankTime = cd + carInfo[1]
		end

		--engage the starter, allow a small overrun
		if cd <= crankTime and carInputs.ignition then
			carState.cranking = true
		else
			carState.cranking = false
		end

		--stop the engine
		if not carInputs.ignition then
			carState.crankAllowed = true
			carRPM = math.applyLag(carRPM, 0, 0.97, 0.003)
		if carRPM < 10 then
			  carRPM = 0 --otherwise it will slowly drop to 0 forever
		end
			ac.setEngineRPM(carRPM)
		else
			carRPM = CAR.rpm
		end

		--engage the starter motor
		if carState.cranking then
			carRPM = math.applyLag(carRPM, engineStartRPM, 0.92, 0.003)
			ac.setEngineRPM(carRPM)
		else
			carRPM = CAR.rpm
		end
	end]]

	------------------------------------------------------------------------------------------------------------------

	--[[ misc and other stuff i dunno


		--local data = ac.accessCarPhysics()
			if data.requestedGearIndex == 1 then
				data.isShifterSupported = 1
			end

			if data.requestedGearIndex == 1 then
				data.gas = 0
			end

		--if  data.steer >=  0 then
			SlipCorr = (-1 * cSlipF)
		else
			SlipCorr = cSlipF
		end

		if car.isAIControlled then
			return    nil
		end]]

	------------------------------------------------------------------------------------------------------------------
	    local data = ac.accessCarPhysics()
             if car.speedKmh > 130 then
             data.controllerInputs[0] = 17
        end
		local data = ac.accessCarPhysics()
             if car.speedKmh < 80 then
             data.controllerInputs[0] = 0
        end
		local data = ac.accessCarPhysics()
             if car.mgukDelivery == 0 then
             data.controllerInputs[1] = 1
			else
			data.controllerInputs[1] = 0		 
        end		
		local data = ac.accessCarPhysics()
             if car.mgukDelivery == 1 then
             data.controllerInputs[2] = 1
			else
			data.controllerInputs[2] = 0			 
        end			
		local data = ac.accessCarPhysics()
             if car.mgukDelivery == 2 then
             data.controllerInputs[3] = 1
			 data.controllerInputs[0] = 20
			else
			data.controllerInputs[3] = 0	
        end				
		local data = ac.accessCarPhysics()
             if data.brake > 0.01 then
             data.controllerInputs[4] = 0.035
			else
			data.controllerInputs[4] = 80	
        end			
end
