local delayUntilStop = 0

function changeVolumeBasedOnPosition(volume)
  if (ac.isInteriorView() ~= true) then
    volume = string.format("%.2f",ac.getAudioVolume('main') * (volume * (1/distanceBetween2Vectors(vec3(0,0,0),ac.getCameraPositionRelativeToCar())))) - 0.06 * ac.getAudioVolume('main') - 0.01
    if volume < 0 then volume = 0 end
  end
  RadioAppData.mediaPlayer:setVolume(volume)
end

return function(dt)
  if not RadioAppData or not RadioAppData.mediaPlayer then
    system.setStatusPriority(0)
    return
  end

  if RadioAppData.mediaPlayer:playing() then
    delayUntilStop = 3
  elseif delayUntilStop > 0 then
    delayUntilStop = delayUntilStop - dt
  end

  local hasAudio = RadioAppData.mediaPlayer:hasAudio()
  local playing = delayUntilStop > 0

  system.setStatusPriority(playing and 10 or 0)
  if RadioAppData.selectedStation and playing then
    system.setNotification(system.appIcon(), RadioAppData.selectedStation[1], hasAudio and 'Now playing' or 'Connecting…')
  else
    system.setNotification(nil)
  end
  --changeVolumeBasedOnPosition(touchscreen.getStoredValues().pickedVolume)
end