--#region
-- ####################################################################################
-- #                                                                                  #
-- #  ██╗███╗   ██╗████████╗███████╗██████╗ ██╗ ██████╗ ██████╗                       #
-- #  ██║████╗  ██║╚══██╔══╝██╔════╝██╔══██╗██║██╔═══██╗██╔══██╗                      #
-- #  ██║██╔██╗ ██║   ██║   █████╗  ██████╔╝██║██║   ██║██████╔╝                      #
-- #  ██║██║╚██╗██║   ██║   ██╔══╝  ██╔══██╗██║██║   ██║██╔══██╗                      #
-- #  ██║██║ ╚████║   ██║   ███████╗██║  ██║██║╚██████╔╝██║  ██║                      #
-- #  ╚═╝╚═╝  ╚═══╝   ╚═╝   ╚══════╝╚═╝  ╚═╝╚═╝ ╚═════╝ ╚═╝  ╚═╝                      #
-- #                                                                                  #
-- #  ███╗   ███╗ ██████╗  ██████╗ ██████╗     ██╗     ██╗ ██████╗ ██╗  ██╗████████╗  #
-- #  ████╗ ████║██╔═══██╗██╔═══██╗██╔══██╗    ██║     ██║██╔════╝ ██║  ██║╚══██╔══╝  #
-- #  ██╔████╔██║██║   ██║██║   ██║██║  ██║    ██║     ██║██║  ███╗███████║   ██║     #
-- #  ██║╚██╔╝██║██║   ██║██║   ██║██║  ██║    ██║     ██║██║   ██║██╔══██║   ██║     #
-- #  ██║ ╚═╝ ██║╚██████╔╝╚██████╔╝██████╔╝    ███████╗██║╚██████╔╝██║  ██║   ██║     #
-- #  ╚═╝     ╚═╝ ╚═════╝  ╚═════╝ ╚═════╝     ╚══════╝╚═╝ ╚═════╝ ╚═╝  ╚═╝   ╚═╝     #
-- #                                                                                  #
-- #  ██████╗ ██╗   ██╗    ██╗   ██╗███████╗████████╗ █████╗ ██╗  ██╗██╗              #
-- #  ██╔══██╗╚██╗ ██╔╝    ██║   ██║██╔════╝╚══██╔══╝██╔══██╗██║  ██║██║              #
-- #  ██████╔╝ ╚████╔╝     ██║   ██║███████╗   ██║   ███████║███████║██║              #
-- #  ██╔══██╗  ╚██╔╝      ██║   ██║╚════██║   ██║   ██╔══██║██╔══██║██║              #
-- #  ██████╔╝   ██║       ╚██████╔╝███████║   ██║   ██║  ██║██║  ██║███████╗         #
-- #  ╚═════╝    ╚═╝        ╚═════╝ ╚══════╝   ╚═╝   ╚═╝  ╚═╝╚═╝  ╚═╝╚══════╝         #
-- #                                                                                  #
-- ####################################################################################
--#endregion
--- Install instructions:
--- Put the section below in your ext_config.ini. Instead of %your mesh name%
--- use some random mesh like the floor (do NOT use actual scriptable
--- displays and emissives)
--- 
--- [SCRIPTABLE_DISPLAY_...]
--- MESHES=%your mesh name%
--- SCRIPT=interior_mood_lightning.lua

--- Available colors. 
--- 
--- Use default SDK ones (rgb.color.xxx)
--- or rgb(R, G, B) where R, G and B are numbers in 0 - 1 range.
--- 
--- If you found a color code that has R, G or B in 0 - 255 range
--- just do rgb(R / 255, G / 255, B / 255)
--- 
--- You can change the brightness/multiplier lower in emissiveMult
local COLORS = {
    rgb(0.2, 0.2, 0.9),
    rgb(0.9, 0.1, 0.1),
    rgb(0.2, 0.9, 0.2),
    rgb(0.9, 0.9, 0.9),
    rgb(0.35, 0.05, 0.55),
    rgb(200 / 255, 64 / 255, 0)
}


--- Main emissives that will always change colors
---
--- mesh names, same as defining emissives in ext_config
local EMISSIVE_MAIN = {
    "int_ambient",
	"int_dash_ambient",
    "int_door_lf_ambient",
    "int_door_rf_ambient"
}

-- Emissives on the left door (won't change when it's opened)
local EMISSIVE_LEFT_DOOR = {

}

-- Emissives on the right door (won't change when it's opened)
local EMISSIVE_RIGHT_DOOR = {

}

--- Extra lights (in the footwell, etc.)
--- 
--- If defined with "[LIGHT_EXTRA_...]" use CSP Debug -> Lights -> Debug lights
--- to see the indexes they get assigned
local LIGHTS = {
    "LIGHT_EXTRA_4",
    "LIGHT_EXTRA_5",
}

-- Change this to change the default color
local currentColor = 1

-- Change emissiveMult to make the emissives brighter if needed
-- (same as 4th value in ext_config emissives)
local emissiveMult = 100

--#region You probably don't need to touch this
local TOTAL_COLORS = #COLORS
local emissiveColor = rgb(0, 0, 0)
local isLeftDoorOpen = false
local isRightDoorOpen = false

local storage = ac.storage({
    savedColor = currentColor
})

local _initialized = false
--#endregion

local function applyColor()
    emissiveColor = emissiveColor:set(COLORS[currentColor]):scale(emissiveMult)

    -- Set main emissive color (everything except doors)
    for _, mesh in pairs(EMISSIVE_MAIN) do
        ac.findNodes(mesh):findMeshes(mesh):setMaterialProperty('ksEmissive', emissiveColor)
    end

    -- Set left door emissive color if it's closed
    if not isLeftDoorOpen and #EMISSIVE_LEFT_DOOR > 0 then
        for _, mesh in pairs(EMISSIVE_LEFT_DOOR) do
            ac.findNodes(mesh):findMeshes(mesh):setMaterialProperty('ksEmissive', emissiveColor)
        end
    end

    -- Set right door emissive color if it's closed
    if not isRightDoorOpen and #EMISSIVE_RIGHT_DOOR > 0 then
        for _, mesh in pairs(EMISSIVE_RIGHT_DOOR) do
            ac.findNodes(mesh):findMeshes(mesh):setMaterialProperty('ksEmissive', emissiveColor)
        end
    end

    for _, light in pairs(LIGHTS) do
        ac.accessCarLight(light).color = COLORS[currentColor]
    end
end

local function nextColor()
    if currentColor == TOTAL_COLORS then
        currentColor = 1
    else
        currentColor = currentColor + 1
    end
    storage.savedColor = currentColor
    applyColor()
end

local function updateDoors()
    -- Left door, replace extraC with appropriate extra switch
    if car.extraC then
        isLeftDoorOpen = true
    elseif isLeftDoorOpen then
        isLeftDoorOpen = false
        applyColor()
    end
    -- Right door, replace extraD with appropriate extra switch
    if car.extraD then
        isRightDoorOpen = true
    elseif isRightDoorOpen then
        isRightDoorOpen = false
        applyColor()
    end
end

local function initialize()
    currentColor = storage.savedColor
    applyColor()
end

function script.update(dt)
    -- To change what Extra scrolls through colors:
    -- extraA = ac.setExtraSwitch(0, false)
    -- extraB = ac.setExtraSwitch(1, false)
    -- extraC = ac.setExtraSwitch(2, false)
    -- and so on

    if not _initialized and not sim.isInMainMenu then
        initialize()
        _initialized = true
    else
        if car.extraA then                  -- replace with extraB, extraC...
            ac.setExtraSwitch(0, false)     -- replace the number with 1, 2...
            if car.extraA then              -- replace with extraB, extraC...
                nextColor()
            end
        end
        updateDoors()
    end
end